% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{qstat}
\alias{qstat}
\title{q-statistic}
\usage{
qstat(cmbdf, listwin, intensities = "I")
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{listwin}{A list of \code{\link{CMBWindow}}s}

\item{intensities}{A \code{\link{CMBDataFrame}} column with measured values.}
}
\value{
Estimated q-statistics for observations in a list of \code{\link{CMBWindow}}s
}
\description{
This function returns an estimated q-statistic for the specified  column
\code{intensities} in a \code{\link{CMBDataFrame}} and the list of
\code{\link{CMBWindow}}s.
}
\details{
The q-statistics is used to measure spatial stratified heterogeneity
and takes values in [0, 1]. It gives the percent of the variance of
\code{intensities} explained by the stratification. 0 corresponds to no spatial
stratified heterogeneity, 1 to perfect spatial stratified heterogeneity.
}
\examples{

## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 1000)
# win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
# win2 <- CMBWindow(theta = c(pi/2,pi,pi/2),  phi = c(0,0,pi/2))
#
# lw <- list(win1, win2)
# qstat(cmbdf, lw)

}
\references{
Wang, J.F, Zhang, T.L, Fu, B.J. (2016). A measure of spatial
stratified heterogeneity. Ecological Indicators. 67: 250–256.
}
