% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubWindow.R
\name{subWindow}
\alias{subWindow}
\title{subWindow}
\usage{
subWindow(cmbdf, win, intersect = TRUE, in.pixels, in.pixels.res = 0)
}
\arguments{
\item{cmbdf}{a \code{\link{CMBDataFrame}}, a \code{data.frame},
a \code{\link{HPDataFrame}}
or \code{\link{CMBDat}} object. If this is a data.frame then it must have
columns labelled x,y,z specifying cartesian coordinates, or
columns labelled theta, phi specifying colatitude and longitude
respectively.}

\item{win}{a \code{\link{CMBWindow}} or a list of CMBWindows}

\item{intersect}{a boolean that determines
the behaviour when \code{win} is a list containing BOTH
regular type and "minus" type windows together (see details).}

\item{in.pixels}{a vector of pixels at resolution
\code{in.pixels.res} whose union contains the
window(s) \code{win} entirely. This will only be used
if \code{cmbdf} is a \code{CMBDataFrame}}

\item{in.pixels.res}{a resolution
(i.e., \eqn{j} such that nside = \code{2^j}) at
which the \code{in.pixels} parameter is specified}
}
\value{
a CMBDataFrame, HPDataFrame, or just a data.frame,
which is restricted to the
region of the sky specified by \code{win}
}
\description{
Restricts a \code{\link{CMBDataFrame}}, \code{CMBDat} object,
or \code{\link{data.frame}} to a \code{\link{CMBWindow}} region.
A single CMBWindow or a list of CMBWindows can be passed to the \code{win}
argument.
}
\details{
Windows that are tagged with \code{set.minus} (see \code{\link{CMBWindow}})
are treated differently from other windows.

If the argument is a list of CMBWindows, then interiors of all windows whose
winType does not include "minus" are united (let \eqn{A} be their union) and
exteriors of all windows whose winType does include "minus" are intersected,
(let \eqn{B} be their intersection). Then, provided that
\code{intersect = TRUE} (the default), the returned CMBDataFrame will
be the points of \code{cmbdf} in the the intersection of \eqn{A} and \eqn{B}.
Otherwise, if \code{intersect = FALSE}, the returned CMBDataFrame
consists of the points of \code{cmbdf} in the union of
\eqn{A} and \eqn{B}.

Note that if \eqn{A} (resp. \eqn{B}) is empty then the returned CMBDataFrame
will be the points of \code{cmbdf} in \eqn{B} (resp. \eqn{A}).
}
\keyword{internal}
