% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_cn.r
\name{cr_cn}
\alias{cr_cn}
\title{Get citations in various formats from CrossRef.}
\usage{
cr_cn(dois, format = "bibtex", style = "apa", locale = "en-US",
  raw = FALSE, .progress = "none", ...)
}
\arguments{
\item{dois}{Search by a single DOI or many DOIs.}

\item{format}{Name of the format. One of "rdf-xml", "turtle", 
"citeproc-json", "citeproc-json-ish", "text", "ris", "bibtex" (default), 
"crossref-xml", "datacite-xml","bibentry", or "crossref-tdm". The format 
"citeproc-json-ish" is a format that is not quite proper citeproc-json}

\item{style}{a CSL style (for text format only). See \code{\link{get_styles}}
for options. Default: apa. If there's a style that CrossRef doesn't support
you'll get a  \code{(500) Internal Server Error}}

\item{locale}{Language locale. See \code{?Sys.getlocale}}

\item{raw}{(logical) Return raw text in the format given by \code{format} 
parameter. Default: FALSE}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", 
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details 
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.)}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\description{
Get citations in various formats from CrossRef.
}
\details{
See \url{http://www.crosscite.org/cn/} for more info on the Crossref
  Content Negotiation API service.
  
  DataCite DOIs: Some values of the \code{format} parameter won't work with 
  DataCite DOIs, i.e. "citeproc-json", "crossref-xml", "crossref-tdm", "onix-xml". 
  
  MEDRA DOIs only work with "rdf-xml", "turtle", "citeproc-json-ish", "ris", 
  "bibtex", "bibentry", "onix-xml".
  
  See examples below.
  
  See \code{\link{cr_agency}}
  
  Note that the format type \code{citeproc-json} uses the CrossRef API at 
  \code{api.crossref.org}, while all others are content negotiated via
  \code{http://data.crossref.org}, \code{http://data.datacite.org} or 
  \code{http://data.medra.org}. DOI agency is checked first (see 
  \code{\link{cr_agency}}).
}
\examples{
\dontrun{
cr_cn(dois="10.1126/science.169.3946.635")
cr_cn(dois="10.1126/science.169.3946.635", "citeproc-json")
cr_cn(dois="10.1126/science.169.3946.635", "citeproc-json-ish")
cr_cn("10.1126/science.169.3946.635", "rdf-xml")
cr_cn("10.1126/science.169.3946.635", "crossref-xml")
cr_cn("10.1126/science.169.3946.635", "text")

# return an R bibentry type
cr_cn("10.1126/science.169.3946.635", "bibentry")
cr_cn("10.6084/m9.figshare.97218", "bibentry")

# return an apa style citation
cr_cn("10.1126/science.169.3946.635", "text", "apa")
cr_cn("10.1126/science.169.3946.635", "text", "harvard3")
cr_cn("10.1126/science.169.3946.635", "text", "elsevier-harvard")
cr_cn("10.1126/science.169.3946.635", "text", "ecoscience")
cr_cn("10.1126/science.169.3946.635", "text", "heredity")
cr_cn("10.1126/science.169.3946.635", "text", "oikos")

# example with many DOIs
dois <- cr_r(2)
cr_cn(dois, "text", "apa")

# Cycle through random styles - print style on each try
stys <- get_styles()
foo <- function(x){
 cat(sprintf("<Style>:\%s\\n", x), sep = "\\n\\n")
 cat(cr_cn("10.1126/science.169.3946.635", "text", style=x))
}
foo(sample(stys, 1))

# Using DataCite DOIs
## some formats don't work
# cr_cn("10.5284/1011335", "text")
# cr_cn("10.5284/1011335", "crossref-xml")
# cr_cn("10.5284/1011335", "crossref-tdm")
## But most do work
cr_cn("10.5284/1011335", "datacite-xml")
cr_cn("10.5284/1011335", "rdf-xml")
# cr_cn("10.5284/1011335", "turtle")
cr_cn("10.5284/1011335", "citeproc-json-ish")
cr_cn("10.5284/1011335", "ris")
cr_cn("10.5284/1011335", "bibtex")
cr_cn("10.5284/1011335", "bibentry")

dois <- c('10.5167/UZH-30455','10.5167/UZH-49216','10.5167/UZH-503',
          '10.5167/UZH-38402','10.5167/UZH-41217')
cat(cr_cn(dois[1]))
cat(cr_cn(dois[2]))
cat(cr_cn(dois[3]))
cat(cr_cn(dois[4]))

# Using Medra DOIs
cr_cn("10.3233/ISU-150780", "onix-xml")

# Get raw output
cr_cn(dois = "10.1002/app.27716", format = "citeproc-json", raw = TRUE)
}
}

