% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdacca.hp.r
\name{rdacca.hp}
\alias{rdacca.hp}
\title{Hierarchical Partitioning for Canonical Analysis}
\usage{
rdacca.hp(
  dv,
  iv,
  method = c("RDA", "dbRDA", "CCA"),
  type = c("adjR2", "R2"),
  trace = FALSE
)
}
\arguments{
\item{dv}{Response variables. if method=dbRDA, dv is the "dist" matrix.}

\item{iv}{Explanatory variables, typically of environmental variables.}

\item{method}{The type of canonical analysis: RDA, dbRDA or CCA, the default is "RDA".}

\item{type}{The type of total explained variation: "adjR2" is adjusted R-squared and "R2" for unadjusted R-squared, the default is "adjR2".}

\item{trace}{logical value, if TRUE, the vaules of commonality (2^N-1for N explanatory variables) are outputed,the default is FALSE.}
}
\value{
a list containing

\item{Method_Type}{The type of canonical analysis and the type of total explained variation.}

\item{R.squared}{A mtrix listing independent effect and its percentage to total explained variation for each explanatory variable.}

\item{Commonality}{If trace=TRUE,a mtrix listing tha value and percentage of all commonality (2^N-1 for N explanatory variables).}

\item{Var.part}{A matrix listing independent effect and its percentage to total explained variation for each explanatory variable.}
}
\description{
Hierarchical Partitioning for Canonical Analysis
}
\details{
This function calculates the independent contribution of each explanatory variable to explained variation (R-squared) on canonical analysis (RDA,CCA and dbRDA),
applying the hierarchy algorithm of Chevan, A. and Sutherland, M. 1991 Hierarchical Partitioning.The American Statistician, 90--96. DOI: 10.1080/00031305.1991.10475776. 
Under the idea of hierarchy algorithm, the shared R2 can be divided into equal components by number of involved variables, and then allocated equally to these variables as joint effects.
The independent contribution of each explanatory variable is the sum of all its allocated common R2 and its unique R2. The order of importance of explanatory variables are determined by their independent contributions.
}
\examples{
library(vegan)
data(mite)
data(mite.env)
#Hellinger-transform the species dataset for RDA to deal with the "double zero" problem
mite.hel <- decostand(mite, "hellinger")
rdacca.hp(mite.hel,mite.env,method="RDA",type="adjR2")
rdacca.hp(vegdist(mite),mite.env,method="dbRDA",type="adjR2")
rdacca.hp(mite,mite.env,method="CCA",type="adjR2")
}
\author{
{Jiangshan Lai} \email{lai@ibcas.ac.cn}

{Pedro Peres-Neto} \email{pedro.peres-neto@concordia.ca}
}
