% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormModVar.R
\docType{class}
\name{NormModVar}
\alias{NormModVar}
\title{\verb{NormModVar}}
\description{
An R6 class for a model variable with Normal uncertainty
}
\details{
A model variable for which the uncertainty in the point estimate can
be modelled with a Normal distribution. The hyperparameters of the
distribution are the mean (\code{mu}) and the standard deviation (\code{sd})
of the uncertainty distribution. The value of \code{mu} is the expected value
of the variable.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{NormModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{NormModVar$new()}}
\item \href{#method-is_probabilistic}{\code{NormModVar$is_probabilistic()}}
\item \href{#method-distribution}{\code{NormModVar$distribution()}}
\item \href{#method-r}{\code{NormModVar$r()}}
\item \href{#method-mean}{\code{NormModVar$mean()}}
\item \href{#method-SD}{\code{NormModVar$SD()}}
\item \href{#method-quantile}{\code{NormModVar$quantile()}}
\item \href{#method-clone}{\code{NormModVar$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description">}\href{../../rdecision/html/ModVar.html#method-description}{\code{rdecision::ModVar$description()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="get">}\href{../../rdecision/html/ModVar.html#method-get}{\code{rdecision::ModVar$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression">}\href{../../rdecision/html/ModVar.html#method-is_expression}{\code{rdecision::ModVar$is_expression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mode">}\href{../../rdecision/html/ModVar.html#method-mode}{\code{rdecision::ModVar$mode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="set">}\href{../../rdecision/html/ModVar.html#method-set}{\code{rdecision::ModVar$set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units">}\href{../../rdecision/html/ModVar.html#method-units}{\code{rdecision::ModVar$units()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a model variable with normal uncertainty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$new(description, units, mu, sigma)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string describing the variable.}

\item{\code{units}}{Units of the quantity; character string.}

\item{\code{mu}}{Hyperparameter with mean of the Normal distribution for 
the uncertainty of the variable.}

\item{\code{sigma}}{Hyperparameter equal to the standard deviation of the
normal distribution for the uncertainty of the variable.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NormModVar} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, i.e. a random
variable that follows a distribution, or an expression involving
random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if probabilistic.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-r"></a>}}
\if{latex}{\out{\hypertarget{method-r}{}}}
\subsection{Method \code{r()}}{
Draw a random sample from the model variable. Normally accessed by a 
call to \code{value(what="r")}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$r(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of samples to draw.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A sample drawn at random.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the mean value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Return the quantiles of the Normal uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Vector of probabilities, in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of quantiles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
