% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiracDistribution.R
\docType{class}
\name{DiracDistribution}
\alias{DiracDistribution}
\title{A Dirac delta function}
\description{
An R6 class representing a Dirac Delta function.
}
\details{
A distribution modelled by a Dirac delta function \eqn{\delta(x-c)}
where \eqn{c} is the hyperparameter (value of the constant). It has 
probability 1 that the value will be equal to \eqn{c} and zero otherwise. 
The mode, mean, quantiles and random samples are all equal to \eqn{c}. It is
acknowledged that there is debate over whether Dirac delta functions are 
true distributions, but the assumption makes little practical difference in 
this case. Inherits from class \code{Distribution}.
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Distribution]{rdecision::Distribution}} -> \code{DiracDistributon}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DiracDistribution$new()}}
\item \href{#method-distribution}{\code{DiracDistribution$distribution()}}
\item \href{#method-mode}{\code{DiracDistribution$mode()}}
\item \href{#method-mean}{\code{DiracDistribution$mean()}}
\item \href{#method-SD}{\code{DiracDistribution$SD()}}
\item \href{#method-quantile}{\code{DiracDistribution$quantile()}}
\item \href{#method-sample}{\code{DiracDistribution$sample()}}
\item \href{#method-clone}{\code{DiracDistribution$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="order">}\href{../../rdecision/html/Distribution.html#method-order}{\code{rdecision::Distribution$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="r">}\href{../../rdecision/html/Distribution.html#method-r}{\code{rdecision::Distribution$r()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="varcov">}\href{../../rdecision/html/Distribution.html#method-varcov}{\code{rdecision::Distribution$varcov()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Dirac Delta function distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$new(const)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{const}}{The value at which the distribution is centred.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{DiracDistribution} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric Value where the distribution is centred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the expected value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Quantiles of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Numeric vector of probabilities, each in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For a Dirac Delta Function all quantiles are returned as the
value at which the distribution is centred.
}

\subsection{Returns}{
Vector of numeric values of the same length as \code{probs}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample"></a>}}
\if{latex}{\out{\hypertarget{method-sample}{}}}
\subsection{Method \code{sample()}}{
Draw and hold a random sample from the model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$sample(expected = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expected}}{If TRUE, sets the next value retrieved by a call to
\code{r()} to be the mean of the distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
