% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiveStreamEventService.R
\name{dfp_createLiveStreamEvents}
\alias{dfp_createLiveStreamEvents}
\title{LiveStreamEventService}
\usage{
dfp_createLiveStreamEvents(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createLiveStreamEventsResponse
}
\description{
Provides methods for creating, updating and retrieving LiveStreamEvent
objects.
This feature is not yet openly available for DFP Video
publishers. Publishers will need to apply for access for this feature
through their account managers.
}
\details{
createLiveStreamEvents

Creates new LiveStreamEvent objects. The following fields are required: 
\itemize{
  \item{LiveStreamEvent name}
  \item{LiveStreamEvent startDateTime}
  \item{LiveStreamEvent endDateTime}
  \item{LiveStreamEvent contentUrls}
  \item{LiveStreamEvent adTags}
}
}
\examples{
\dontrun{
 res <- dfp_createLiveStreamEvents(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/LiveStreamEventService#createLiveStreamEvents}{Google Documentation for createLiveStreamEvents}
}
