% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qDZ_single.R
\name{qDZ_single}
\alias{qDZ_single}
\title{Similarity-sensitive diversity of a single population}
\usage{
qDZ_single(proportions, q, Z = diag(nrow(proportions)), Zp = Z \%*\%
  proportions)
}
\arguments{
\item{proportions}{\code{vector} of mode \code{numeric}; contains the 
relative proportions of different individuals/types in a population.}

\item{q}{object of class \code{numeric}; contains the order of diversity 
measurement.}

\item{Z}{two-dimensional \code{matrix} of mode \code{numeric}; contains the 
pair-wise similarity of individuals/types in a population.}

\item{Zp}{two-dimensional \code{matrix} of mode \code{numeric}; contains 
the ordinariness of individuals/types in population.}
}
\value{
Returns the similarity-sensitive diversity of order \emph{q}.
}
\description{
Calculates the similarity-sensitive diversity of order \emph{q} of a single  
population with given relative proportions.
}
\examples{
pop <- sample(1:50, 5)

# Create similarity matrix
Z <- diag(1, length(pop))
Z[Z==0] <- 0.4

# Calculate similarity-sensitive diversity of order 0 (species richness)
qDZ_single(pop, 0, Z)

}
