% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qD_single.R
\name{qD_single}
\alias{qD_single}
\title{Hill number / naive diversity of a single population}
\usage{
qD_single(proportions, q)
}
\arguments{
\item{proportions}{\code{vector} of mode \code{numeric}; contains the 
relative proportions of different individuals/types in a population.}

\item{q}{object of class \code{numeric}; contains the order of diversity 
measurement.}
}
\value{
Returns the naive divesity of order \emph{q}.
}
\description{
Calculates the Hill number (naive diversity) of order \emph{q} of a single
population with given relative proportions.
}
\examples{
pop <- sample(1:50, 5)
qD_single(pop, 0)

}
