% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdms.R
\name{rdms}
\alias{rdms}
\title{Analysis of RD designs with cumulative cutoffs or two running variables}
\usage{
rdms(Y, X, C, X2 = NULL, zvar = NULL, C2 = NULL, range.l = NULL,
  range.r = NULL, xnorm = NULL, pooled.opt = NULL, hvec = NULL,
  bvec = NULL, pvec = NULL, kernelvec = NULL, fuzzy = NULL,
  plot = FALSE)
}
\arguments{
\item{Y}{outcome variable.}

\item{X}{running variable.}

\item{C}{vector of cutoffs.}

\item{X2}{if specified, second running variable.}

\item{zvar}{if X2 is specified, treatment indicator.}

\item{C2}{if specified, second vector of cutoffs.}

\item{range.l}{range of the running variable to be used for estimation around the cutoff from the left.}

\item{range.r}{range of the running variable to be used for estimation around the cutoff from the right.}

\item{xnorm}{normalized running variable to estimate pooled effect.}

\item{pooled.opt}{options to be passed to \code{rdrobust()} to calculate pooled estimand.}

\item{hvec}{bandwidths to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{bvec}{bandwidths for the bias to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{pvec}{order of the polynomials to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{kernelvec}{kernels to be passed to \code{rdrobust()} to calculate cutoff-specific estimates.Should be a vector of length equal to the number of different cutoffs.}

\item{fuzzy}{specifies a fuzzy design.}

\item{plot}{plots cutoff-specific estimates and weights.}
}
\value{
\item{B}{vector of bias-corrected coefficients}
\item{V}{variance-covariance matrix of the estimators}
\item{Coefs}{vector of conventional coefficients}
\item{Nh}{vector of sample sizes within bandwidth at each cutoff}
\item{CI}{bias corrected confidence intervals}
\item{H}{bandwidth used at each cutoff}
}
\description{
\code{rdms()} analyzes RD designs with cumulative cutoffs or two running variables.
}
\examples{
# Toy dataset: cumulative cutoffs
X <- runif(1000,0,100)
C <- c(33,66)
Y <- (1+X)*(X<C[1])+(0.8+0.8*X)*(X>=C[1]&X<C[2])+(1.2+1.2*X)*(X>=C[2]) + rnorm(1000)
# rmds: basic syntax
tmp <- rdms(Y,X,C)


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2018). \href{https://sites.google.com/site/rdpackages/rdmulti/Cattaneo-Titiunik-VazquezBare_2018_rdmulti.pdf}{Analysis of Regression Discontinuity Designs with Multiple Cutoffs or Multiple Scores}. \emph{Working paper, University of Michigan}.
}
\author{
Matias Cattaneo, University of Michigan. \email{cattaneo@umich.edu}

Rocio Titiunik, University of Michigan. \email{titiunik@umich.edu}

Gonzalo Vazquez-Bare, University of Michigan. \email{gvazquez@umich.edu}
}
