% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\docType{data}
\name{metaIndex}
\alias{metaIndex}
\title{station info (meta data) available on the DWD CDC FTP server}
\format{data.frame with ca 38k rows for 12 columns:
        \code{Stations_id}, \code{von_datum}, \code{bis_datum}
        \code{Stationshoehe}, \code{geoBreite}, \code{geoLaenge}
        \code{Stationsname}, \code{Bundesland},
        \code{res}, \code{var}, \code{per} (see \code{\link{selectDWD}}),
        \code{hasfile}}
\source{
Deutscher WetterDienst / Climata Data Center  FTP Server
}
\description{
A data.frame with the contents of all the station description files
(..._Beschreibung_Stationen.txt) in the folders hourly, daily and monthly at
\url{ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate/}.
Created with \code{\link{createIndex}} in the last section of
\url{https://github.com/brry/rdwd/blob/master/R/meta.R}
In functions, you can access it with \code{rdwd:::metaIndex}.
}
\examples{

data(metaIndex)
head(metaIndex)
# in functions, you can use head(rdwd:::metaIndex)

# example usages are in ?rdwd


}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, June-Nov 2016
}
\seealso{
\code{\link{geoIndex}} for metadata per location,
         \code{\link{fileIndex}}, \code{\link{findID}}, \code{\link{metaInfo}}
}
\keyword{datasets}

