% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.grib2}
\alias{readDWD.grib2}
\title{read nwp forecast data}
\usage{
readDWD.grib2(file, bargs = NULL, toraster = TRUE, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
cosmo-d2_germany_regular-lat-lon_single-level_2021010100_005_T_2M.grib2.bz2}

\item{bargs}{Named list of arguments passed to
\code{\link[R.utils:compressFile]{R.utils::bunzip2()}}, see \code{gargs} in \code{\link[=readDWD.raster]{readDWD.raster()}}. DEFAULT: NULL}

\item{toraster}{Logical: convert \link[rgdal:readGDAL]{rgdal::readGDAL} output with \code{\link[raster:raster]{raster::raster()}}?
DEFAULT: TRUE}

\item{quiet}{Silence readGDAL completely, including warnings on
discarded ellps / datum.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[rgdal:readGDAL]{rgdal::readGDAL()}},}
}
\value{
rgdal or raster object, depending on \code{toraster}
}
\description{
read gridded numerical weather prediction data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests
# Deactivated 2021-04-08 since readDWD.grib2 -> rgdal::readGDAL -> Error:
# **.grib2 is a grib file, but no raster dataset was successfully identified.
warning("readDWD.grib2 is not tested due to unresolved problems.")
if(FALSE){
nwp_t2m_base <- "ftp://opendata.dwd.de/weather/nwp/icon-d2/grib/03/p"
nwp_urls <- indexFTP("", base=nwp_t2m_base, dir=tempdir())
nwp_file <- dataDWD(nwp_urls[6], base=nwp_t2m_base, dir=tempdir(),
                    joinbf=TRUE, dbin=TRUE, read=FALSE)
nwp_data <- readDWD(nwp_file, quiet=TRUE)
plotRadar(nwp_data, project=FALSE)

nwp_data_rgdal <- readDWD(nwp_file, toraster=FALSE)
sp::plot(nwp_data_rgdal)
}
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}\cr
\url{https://www.dwd.de/EN/ourservices/nwp_forecast_data/nwp_forecast_data.html}\cr
\url{https://www.dwd.de/EN/aboutus/it/functions/Teasergroup/grib.html}\cr
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2021.
}
