% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Recur}
\alias{plot.Recur}
\title{Produce Event Plot or Cumulative Sample Mean Function Plot}
\usage{
\method{plot}{Recur}(x, CSM = FALSE, event.result = c("increasing",
  "decreasing", "asis"), csm.adjrisk = TRUE, csm.smooth = FALSE,
  control = list(), ...)
}
\arguments{
\item{x}{an object of class \code{Recur} returned by the \code{Recur()} function.}

\item{CSM}{an optional logical value indicating whether the cumulative sample mean (CSM) function will
be plotted instead of the event plot (default).}

\item{event.result}{an optional character string that is passed to the \code{plotEvents()} function as \code{result}, e.g., see \code{\link{plotEvents}}.
This argument is used to specify whether the event plot is sorted by the subjects' terminal time.
The available options are
\describe{
  \item{\code{increasing}}{sort the terminal time from in increasing order (default). This places longer terminal times on top. }
  \item{\code{decreasing}}{sort the terminal time from in decreasing order (default). This places shorter terminal times on top. }
  \item{\code{asis}}{present the as is, without sorting.}
}}

\item{csm.adjrisk}{an optional logical value that is passed to the \code{plotCSM()} function as \code{adjrisk}, e.g., see \code{\link{plotCSM}}.
This argument indicates whether risk set will be adjusted, e.g., if \code{TRUE}, subjects leave the risk set after terminal times.}

\item{csm.smooth}{an optional logical value that is passed to the \code{plotCSM()} function as \code{smooth}, e.g., see \code{\link{plotCSM}}.
This argument indicates whether to add a smooth curve obtained from a monotone increasing P-splines implemented in package \code{scam}.}

\item{control}{a list of control parameters. See \bold{Details}.}

\item{...}{graphical parameters to be passed to methods.
These include \code{xlab}, \code{ylab}, \code{main}, and more. See \bold{Details}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot whether the event plot or the cumulative sample mean (CSM) function for an \code{Recur} object.
}
\details{
The argument \code{control} consists of options with argument defaults to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Subject" for event plot and "Cumulative mean" for CSM plot.}
  \item{main}{customizable title, the default value is "Recurrent event plot" when \code{CSM = FALSE} and
"Sample cumulative mean function plot" when \code{CSM = TRUE}.}
  \item{terminal.name}{customizable label for terminal event, default value is "Terminal event".}
  \item{recurrent.name}{customizable legend title for recurrent event, default value is "Recurrent events".}
  \item{recurrent.types}{customizable label for recurrent event type, default value is \code{NULL}.}
  \item{alpha}{between 0 and 1, controls the transparency of points.}
}
The \code{xlab}, \code{ylab} and \code{main} parameters can also be passed down without specifying a \code{control} list. See \bold{Examples}.
}
\examples{
set.seed(1)
dat <- simSC(30, c(-1, 1), c(-1, 1))
reObj <- with(dat, Recur(Time, id, event, status))

## Event plots:
plot(reObj)
plot(reObj, event.result = "decreasing")
plot(reObj, event.result = "asis")
plot(reObj, control = list(xlab = "User xlab", ylab = "User ylab", main = "User title"))

## CSM plots
plot(reObj, CSM = TRUE)
plot(reObj, CSM = TRUE, csm.adjrisk = FALSE)
plot(reObj, CSM = TRUE, csm.smooth = TRUE)
plot(reObj, CSM = TRUE, control = list(xlab = "User xlab", ylab = "User ylab", main = "User title"))

## With (hypothetical) multiple event types
set.seed(1)
reObj2 <- with(dat, Recur(Time, id, event * sample(1:3, nrow(dat), TRUE), status))
plot(reObj2)
plot(reObj2, event.result = "decreasing")
plot(reObj2, event.result = "asis")

plot(reObj2, CSM = TRUE)
plot(reObj2, CSM = TRUE, csm.adjrisk = FALSE)
plot(reObj2, CSM = TRUE, csm.smooth = TRUE)

}
\seealso{
\code{\link{Recur}}
}
\keyword{Plots}
