% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{reactableTheme}
\alias{reactableTheme}
\title{Theme options}
\usage{
reactableTheme(
  color = NULL,
  backgroundColor = NULL,
  borderColor = NULL,
  borderWidth = NULL,
  stripedColor = NULL,
  highlightColor = NULL,
  cellPadding = NULL,
  style = NULL,
  tableStyle = NULL,
  headerStyle = NULL,
  groupHeaderStyle = NULL,
  tableBodyStyle = NULL,
  rowGroupStyle = NULL,
  rowStyle = NULL,
  rowStripedStyle = NULL,
  rowHighlightStyle = NULL,
  rowSelectedStyle = NULL,
  cellStyle = NULL,
  footerStyle = NULL,
  inputStyle = NULL,
  filterInputStyle = NULL,
  searchInputStyle = NULL,
  selectStyle = NULL,
  paginationStyle = NULL,
  pageButtonStyle = NULL,
  pageButtonHoverStyle = NULL,
  pageButtonActiveStyle = NULL,
  pageButtonCurrentStyle = NULL
)
}
\arguments{
\item{color}{Default text color.}

\item{backgroundColor}{Default background color.}

\item{borderColor}{Default border color.}

\item{borderWidth}{Default border width.}

\item{stripedColor}{Default row stripe color.}

\item{highlightColor}{Default row highlight color.}

\item{cellPadding}{Default cell padding.}

\item{style}{Additional CSS for the table.}

\item{tableStyle}{Additional CSS for the table element (excludes
the pagination bar and search input).}

\item{headerStyle}{Additional CSS for header cells.}

\item{groupHeaderStyle}{Additional CSS for group header cells.}

\item{tableBodyStyle}{Additional CSS for the table body element.}

\item{rowGroupStyle}{Additional CSS for row groups.}

\item{rowStyle}{Additional CSS for rows.}

\item{rowStripedStyle}{Additional CSS for striped rows.}

\item{rowHighlightStyle}{Additional CSS for highlighted rows.}

\item{rowSelectedStyle}{Additional CSS for selected rows.}

\item{cellStyle}{Additional CSS for cells.}

\item{footerStyle}{Additional CSS for footer cells.}

\item{inputStyle}{Additional CSS for inputs.}

\item{filterInputStyle}{Additional CSS for filter inputs.}

\item{searchInputStyle}{Additional CSS for the search input.}

\item{selectStyle}{Additional CSS for table select controls.}

\item{paginationStyle}{Additional CSS for the pagination bar.}

\item{pageButtonStyle, pageButtonHoverStyle, pageButtonActiveStyle, pageButtonCurrentStyle}{Additional CSS for page buttons, page buttons with hover or active
states, and the current page button.}
}
\value{
A theme options object that can be used to customize the default
styling in \code{reactable()}.
}
\description{
Use \code{reactableTheme()} to customize the default styling of a table.
You can set theme variables to change the default styles, or add custom CSS
to specific elements of the table.

The \code{color} variables are specified as character strings of CSS color values.
The \code{width} and \code{padding} variables are specified as either character strings
of CSS width and padding values, or numeric pixel values. The \code{style} arguments
take custom CSS as named lists of camelCased properties.

To set the default theme for all tables, use the global \code{reactable.theme} option.
}
\details{
You can use nested CSS selectors in \code{style} arguments to target
the current element, using \code{&} as the selector, or other child elements
(just like in Sass). This is useful for adding pseudo-classes like \verb{&:hover},
or adding styles in a certain context like \verb{.outer-container &}.
}
\examples{
reactable(
  iris[1:30, ],
  searchable = TRUE,
  striped = TRUE,
  highlight = TRUE,
  bordered = TRUE,
  theme = reactableTheme(
    borderColor = "#dfe2e5",
    stripedColor = "#f6f8fa",
    highlightColor = "#f0f5f9",
    cellPadding = "8px 12px",
    style = list(
      fontFamily = "-apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif"
    ),
    searchInputStyle = list(width = "100\%")
  )
)

# Set the default theme for all tables
options(reactable.theme = reactableTheme(
  color = "hsl(233, 9\%, 87\%)",
  backgroundColor = "hsl(233, 9\%, 19\%)",
  borderColor = "hsl(233, 9\%, 22\%)",
  stripedColor = "hsl(233, 12\%, 22\%)",
  highlightColor = "hsl(233, 12\%, 24\%)",
  inputStyle = list(backgroundColor = "hsl(233, 9\%, 25\%)"),
  selectStyle = list(backgroundColor = "hsl(233, 9\%, 25\%)"),
  pageButtonHoverStyle = list(backgroundColor = "hsl(233, 9\%, 25\%)"),
  pageButtonActiveStyle = list(backgroundColor = "hsl(233, 9\%, 28\%)")
))

reactable(
  iris[1:30, ],
  filterable = TRUE,
  showPageSizeOptions = TRUE,
  striped = TRUE,
  highlight = TRUE,
  details = function(index) paste("Details for row", index)
)

# Use nested selectors to highlight headers when sorting
reactable(
  iris[1:30, ],
  columns = list(Sepal.Length = colDef(sortable = FALSE)),
  showSortable = TRUE,
  theme = reactableTheme(
    headerStyle = list(
      "&:hover[aria-sort]" = list(background = "hsl(0, 0\%, 96\%)"),
      "&[aria-sort='ascending'], &[aria-sort='descending']" = list(background = "hsl(0, 0\%, 96\%)"),
      borderColor = "#555"
    )
  )
)

}
