% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex-readwrite.R
\name{writeGenalex}
\alias{writeGenalex}
\title{Write GenAlEx-format genotypes to a text file}
\usage{
writeGenalex(x, file, quote = FALSE, sep = "\\t", eol = "\\n", na = "0",
  na.character = "", check.annotation = TRUE)
}
\arguments{
\item{x}{Annotated data frame of class \code{'genalex'}}

\item{file}{File name or connection for writing.  If given as \code{""},
\code{stdout()} is used.}

\item{quote}{Logical value (\code{TRUE} or \code{FALSE}).  If \code{TRUE},
all character data are surrounded by double quotes, and all header fields
except for counts are quoted if they exist.  Note that genotype data will
not be quoted, as they are' numeric values.  Data in the extra columns
will be quoted, unless some have been made numeric since being read.  If
\code{FALSE}, nothing is quoted.}

\item{sep}{Column separator for output (defaults to \code{"\t"}).}

\item{eol}{End-of-line character used for output (defaults to \code{"\n"}).}

\item{na}{The string to use when writing missing values in genotype
data.  Defaults to \code{"0"}.}

\item{na.character}{The string to use when writing missing values in
character data.  Defaults to \code{""}.}

\item{check.annotation}{If \code{TRUE}, the annotations for the dataset
are checked using \code{is.genalex(x, force = TRUE, skip.strings = TRUE)}.
If that returns \code{FALSE}, nothing is written and an error is generated.}
}
\value{
No value is returned.
}
\description{
Writes genotype data encoded in an annotated data frame of class
\code{'genalex'} to a GenAlEx-format text file.  Extra data columns are
written immediately to the right of genotype columns.  GenAlEx and its
documentation are available at
\url{http://biology-assets.anu.edu.au/GenAlEx}.
}
\details{
This function writes genotypes and associated information within an
annotated data frame of class \code{'genalex'} to a text file in GenAlEx
format. More information is available in the description for
\code{\link{readGenalex}}, and at the GenAlEx website at
\url{http://biology-assets.anu.edu.au/GenAlEx}.

Doing \code{writeGenalex(readGenalex("file.txt"), "file-write.txt")} won't
necessarily produce an output file identical to the input file.  Three
areas for which this will likely be true are:

\enumerate{
   \item Names on columns for alleles other than the first in a locus,
         which are ignored by \code{readGenalex}, converted to a simple
         concatenation of locus name and allele number in the resulting
         class \code{'genalex'}, and are left out of the output of
         \code{writeGenalex}.
   \item Locations of additional data columns beyond the genotype columns,
         which \code{readGenalex} should collect wherever there are named
         columns to the right of the genotype columns, and which
         \code{writeGenalex} will write immediately to the right of the
         genotype columns.  The same column names are used when writing
         as were present when reading.
   \item Missing data will be coded with the values in \code{na} and
         \code{na.character}, regardless of the coding used when the data
         were read.
}
}
\examples{
data(Qagr_adult_genotypes)
# lots of output to terminal
writeGenalex(Qagr_adult_genotypes, file = "")
}
\author{
Douglas G. Scofield
}
\references{
Peakall, R. and Smouse P.E. (2012) GenAlEx 6.5: genetic analysis
in Excel. Population genetic software for teaching and research-an update.
\emph{Bioinformatics} 28, 2537-2539.

Peakall, R. and Smouse P.E. (2006) GENALEX 6: genetic analysis in Excel.
Population genetic software for teaching and research. \emph{Molecular
Ecology Notes} 6, 288-295.
}
\seealso{
\code{\link{readGenalex}}
}
\keyword{attribute}
\keyword{file}
\keyword{manip}

