% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{guess_encoding}
\alias{guess_encoding}
\title{Guess encoding of file.}
\usage{
guess_encoding(file, n_max = 10000, threshold = 0.2)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded. Remote gz files can also be automatically downloaded &
   decompressed.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{n_max}{Number of lines to read. If \code{n} is -1, all lines in
file will be read.}

\item{threshold}{Only report guesses above this threshold of certainty.}
}
\description{
Uses \code{\link[stringi]{stri_enc_detect}}: see the documentation there
for caveats.
}
\examples{
guess_encoding(system.file("extdata/mtcars.csv", package = "readr"))
guess_encoding("a\\n\\u00b5\\u00b5")
}

