% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tools.R
\name{get.label}
\alias{get.label}
\title{Get Stata Label Table for a Label Set}
\usage{
get.label(dat, label.name)
}
\arguments{
\item{dat}{\emph{data.frame.} Data.frame created by \code{read.dta13}.}

\item{label.name}{\emph{character.} Name of the Stata label set}
}
\value{
Returns a named vector of code numbers
}
\description{
Retrieve the value labels for a specific Stata label set.
}
\details{
This function returns the table of factor levels which represent a Stata label set.
The name of a label set for a variable can be obtained by \code{\link{get.label.name}}.
}
\examples{
dat <- read.dta13(system.file("extdata/statacar.dta", package="readstata13"))
labname <- get.label.name(dat,"type")
get.label(dat, labname)
}
\author{
Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Sebastian Jeworutzki \email{sebastian.jeworutzki@ruhr-uni-bochum.de}
}

