% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grp_generics.R, R/mthd_renewSlot.R
\name{renewSlot}
\alias{renewSlot}
\alias{renewSlot-Ready4Module}
\alias{renewSlot,Ready4Module-method}
\title{Apply the renew method to a model module slot}
\usage{
renewSlot(x, slot_nm_1L_chr, new_val_xx = "use_renew_mthd", ...)

\S4method{renewSlot}{Ready4Module}(x, slot_nm_1L_chr, new_val_xx = "use_renew_mthd", ...)
}
\arguments{
\item{x}{An object of class Ready4Module}

\item{slot_nm_1L_chr}{Slot name (a length one character vector)}

\item{new_val_xx}{New value (slot dependent object type), Default 'use_renew_mthd'}

\item{...}{Additional arguments}
}
\value{
A model module (an instance of a class that inherits from Ready4Module) of the same class as that supplied to the method.

A ready4 model module (an instance of a class that inherits from Ready4Module) of the same class as that supplied to the method.
}
\description{
renewSlot() is a "setter" method that renews (sets) the value of a specified model module slot with either the value returned by applying the renew method to that slot (the default behaviour) or a supplied new value.

renewSlot method applied to Ready4Module
}
\examples{
X <- Ready4Module()
X <- renewSlot(X, "dissemination_1L_chr", new_val_xx = "Some new text.")
}
