% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency.R
\name{powconsistencytest}
\alias{powconsistencytest}
\title{Power of Consistency Tests, Partial Stratification}
\usage{
powconsistencytest(n1, n2, pmat, alpha = 0.05, sim = TRUE, nsim = 10000)
}
\arguments{
\item{n1}{Vector of anticipated n1 counts (sample size in the first event),
each element corresponding to one stratum.}

\item{n2}{Vector of anticipated n2 counts (sample size in the second event),
each element corresponding to one stratum.}

\item{pmat}{Matrix of assumed movement probabilities between strata, with
rows corresponding to first-event strata and columns corresponding to
second-event strata, and an additional column corresponding to the
probability of NOT being recaptured in the second event.  Values will be
standardized by row, that is, by first-event strata.  See note on usage
below.}

\item{alpha}{Significance level for testing.  Defaults to \code{0.05}}

\item{sim}{Whether to conduct power calculation by simulation as well as
Cohen's method.  Defaults to \code{TRUE}.}

\item{nsim}{Number of simulations if \code{sim} is \code{TRUE}.  Defaults to
\code{10000}.}
}
\value{
An object of class \code{"recapr_consistencypow"} with the following
  components: \itemize{ \item{\code{pwr1_c}} {Power of the first test,
  according to Cohen's method} \item{\code{pwr1_sim}} {Power of the first
  test, from simulation} \item{\code{ntest1}} {The sample size used for the
  first test} \item{\code{p0test1}} {The null-hypothesis probabilities for
  the first test} \item{\code{p1test1}} {The alt-hypothesis probabilities for
  the first test} \item{\code{pwr2_c}} {Power of the second test, according
  to Cohen's method} \item{\code{pwr2_sim}} {Power of the second test, from
  simulation} \item{\code{ntest2}} {The sample size used for the second test}
  \item{\code{p0test2}} {The null-hypothesis probabilities for the second
  test} \item{\code{p1test2}} {The alt-hypothesis probabilities for the
  second test} \item{\code{pwr3_c}} {Power of the third test, according to
  Cohen's method} \item{\code{pwr3_sim}} {Power of the third test, from
  simulation} \item{\code{ntest3}} {The sample size used for the third test}
  \item{\code{p0test3}} {The null-hypothesis probabilities for the third
  test} \item{\code{p1test3}} {The alt-hypothesis probabilities for the third
  test} \item{\code{alpha}} {The significance level used} }
}
\description{
Conducts power calculations of the chi-squared tests for the
  consistency of the Petersen-type abundance estimator, in a partial
  stratification setting, such as by time or geographic area.  In the case of
  partial stratification, individuals may move from one stratum to another
  between the first and second sampling events, and strata do not need to be
  the same between events.
}
\note{
The movement probability matrix specified in \code{pmat} is considered
  conditional on each row, that is, first-event strata, with columns
  corresponding to second-event strata and the final column specifying the
  probability of not being recaptured in the second event.  Values do not
  need to sum to one for each row, but will be standardized by the function
  to sum to one.

  A \code{pmat} with a first row equal to \code{(0.05, 0.1, 0.15, 0.7)} would
  imply a 5 percent chance that individuals captured in the first-event
  strata 1 will be recaptured in second-event strata 1, and a 70 percent
  chance that individuals captured in the first-event strata 1 will not be
  recaptured in event 2.

  Because of the row-wise scaling, specifying a row equal to \code{(0.05,
  0.1, 0.15, 0.7)} would be equivalent to that row having values \code{(1, 2, 3, 14)}.
}
\examples{
mat <- matrix(c(4,3,2,1,10,3,4,3,2,10,2,3,4,3,10,1,2,3,4,10),
    nrow=4, ncol=5, byrow=TRUE)
powconsistencytest(n1=c(50,50,50,50), n2=c(50,50,50,50), pmat=mat)

mat <- matrix(c(4,3,2,1,10,4,3,2,1,10,4,3,2,1,10,4,3,2,1,10),
    nrow=4, ncol=5, byrow=TRUE)
powconsistencytest(n1=c(50,50,50,50), n2=c(50,50,50,50), pmat=mat)

mat <- matrix(c(1,1,1,1,10,2,2,2,2,10,3,3,3,3,10,4,4,4,4,10),
    nrow=4, ncol=5, byrow=TRUE)
powconsistencytest(n1=c(50,50,50,50), n2=c(50,50,50,50), pmat=mat)

mat <- matrix(c(1,1,1,1,10,1,1,1,1,10,1,1,1,1,10,1,1,1,1,10),
    nrow=4, ncol=5, byrow=TRUE)
powconsistencytest(n1=c(50,50,50,50), n2=c(20,30,40,50), pmat=mat)

mat <- matrix(c(1,1,1,1,5,1,1,1,1,8,1,1,1,1,10,1,1,1,1,15),
    nrow=4, ncol=5, byrow=TRUE)
powconsistencytest(n1=c(50,50,50,50), n2=c(50,50,50,50), pmat=mat)
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral
  sciences (2nd ed.). Hillsdale,NJ: Lawrence Erlbaum.

  Code adapted from the 'pwr' package: Stephane Champely (2015). pwr: Basic
  Functions for Power Analysis. R package version 1.1-3.
  https://CRAN.R-project.org/package=pwr
}
\seealso{
\link{consistencytest}, \link{NDarroch}
}
\author{
Matt Tyers
}
