% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developer.R
\name{developer_functions}
\alias{developer_functions}
\title{Developer functions for creating recipes steps}
\description{
This page provides a comprehensive list of the exported functions for
creating recipes steps and guidance on how to use them.
}
\section{Creating steps}{
\code{\link[=add_step]{add_step()}} and \code{\link[=add_check]{add_check()}} are required when creating a new step. The
output of \code{\link[=add_step]{add_step()}} should be the return value of all steps and should
have the following format:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{step_example <- function(recipe,
                         ...,
                         role = NA,
                         trained = FALSE,
                         skip = FALSE,
                         id = rand_id("example")) \{
  add_step(
    recipe,
    step_example_new(
      terms = enquos(...),
      role = role,
      trained = trained,
      skip = skip,
      id = id
    )
  )
\}
}\if{html}{\out{</div>}}

\code{\link[=rand_id]{rand_id()}} should be used in the arguments of \code{step_example()} to specify
the argument, as we see in the above example.

\code{\link[=recipes_pkg_check]{recipes_pkg_check()}} should be used in \code{step_example()} functions together
with \code{\link[=required_pkgs]{required_pkgs()}} to alert users that certain other packages are
required. The standard way of using this function is the following format:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{recipes_pkg_check(required_pkgs.step_example())
}\if{html}{\out{</div>}}

\code{\link[=step]{step()}} and \code{\link[=check]{check()}} are used within the \verb{step_*_new()} function that you
use in your new step. It will be used in the following way:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{step_example_new <- function(terms, role, trained, skip, id) \{
  step(
    subclass = "example",
    terms = terms,
    role = role,
    trained = trained,
    skip = skip,
    id = id
  )
\}
}\if{html}{\out{</div>}}

\code{\link[=recipes_eval_select]{recipes_eval_select()}} is used within \verb{prep.step_*()} functions, and are
used to turn the \code{terms} object into a character vector of the selected
variables.

It will most likely be used like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{col_names <- recipes_eval_select(x$terms, training, info)
}\if{html}{\out{</div>}}

\code{\link[=recipes_argument_select]{recipes_argument_select()}} is used within \verb{prep.step_*()} functions in the
same way as \code{\link[=recipes_eval_select]{recipes_eval_select()}} but is intended to be used for arguments
such as \code{denom} in \code{\link[=step_ratio]{step_ratio()}}.

It will most likely be used like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{outcome_var <- recipes_argument_select(x$outcome, training, info)
}\if{html}{\out{</div>}}

\code{\link[=check_type]{check_type()}} can be used within \verb{prep.step_*()} functions to check that the
variables passed in are the right types. We recommend that you use the
\code{types} argument as it offers higher flexibility and it matches the types
defined by \code{\link[=.get_data_types]{.get_data_types()}}. When using \code{types} we find it better to be
explicit, e.g. writing \code{types = c("double", "integer")} instead of \code{types = "numeric"}, as it produces cleaner error messages.

It should be used like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{check_type(training[, col_names], types = c("double", "integer"))
}\if{html}{\out{</div>}}

\code{\link[=check_options]{check_options()}} can be used within \verb{prep.step_*()} functions to check that
the \code{options} argument contains the right elements. It doens't check the
types of the elements, just that \code{options} is a named list and it includes
or excludes some names.

It should be used like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# When you know some arguments are excluded
check_options(xoptions, exclude = c("x", "pattern"))

# When you know all legal elements
check_options(xoptions, include = c("nthread", "eps"))
}\if{html}{\out{</div>}}

\code{\link[=check_new_data]{check_new_data()}} should be used within \verb{bake.step_*()}. This function is
used to make check that the required columns are present in the data. It
should be one of the first lines inside the function.

It should be used like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{check_new_data(names(object$columns), object, new_data)
}\if{html}{\out{</div>}}

\code{\link[=check_name]{check_name()}} should be used in \verb{bake.step_*()} functions for steps that add
new columns to the data set. The function throws an error if the column names
already exist in the data set. It should be called before adding the new
columns to the data set.

\code{\link[=get_keep_original_cols]{get_keep_original_cols()}} and \code{\link[=remove_original_cols]{remove_original_cols()}} are used within steps
with the \code{keep_original_cols} argument. \code{\link[=get_keep_original_cols]{get_keep_original_cols()}} is used in
\verb{prep.step_*()} functions for steps that were created before the
\code{keep_original_cols} argument was added, and acts as a way to throw a warning
that the user should regenerate the recipe. \code{\link[=remove_original_cols]{remove_original_cols()}} should
be used in \verb{bake.step_*()} functions to remove the original columns. It is
worth noting that \code{\link[=remove_original_cols]{remove_original_cols()}} can remove multiple columns at
once and when possible should be put outside \code{for} loops.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{new_data <- remove_original_cols(new_data, object, names_of_original_cols)
}\if{html}{\out{</div>}}

\code{\link[=recipes_remove_cols]{recipes_remove_cols()}} should be used in \verb{prep.step_*()} functions, and is
used to remove columns from the data set, either by using the
\code{object$removals} field or by using the \code{col_names} argument.

\code{\link[=recipes_names_predictors]{recipes_names_predictors()}} and \code{\link[=recipes_names_outcomes]{recipes_names_outcomes()}} should be used in
\verb{prep.step_*()} functions, and are used to get names of predictors and
outcomes.

\code{\link[=get_case_weights]{get_case_weights()}} and \code{\link[=are_weights_used]{are_weights_used()}} are functions that help you
extract case weights and help determine if they are used or not within the
step. They will typically be used within the \verb{prep.step_*()} functions if the
step in question supports case weights.

\code{\link[=print_step]{print_step()}} is used inside \verb{print.step_*()} functions. This function is
replacing the internally deprecated \code{\link[=printer]{printer()}} function.

\code{\link[=sel2char]{sel2char()}} is mostly used within \verb{tidy.step_*()} functions to turn
selections into character vectors.

\code{\link[=names0]{names0()}} creates a series of \code{num} names with a common prefix. The names
are numbered with leading zeros (e.g. \code{prefix01}-\code{prefix10} instead of
\code{prefix1}-\code{prefix10}). This is useful for many types of steps that produce
new columns.
}

\section{Interacting with recipe objects}{
\code{\link[=recipes_ptype]{recipes_ptype()}} returns the ptype, expected variables and types, that a
recipe object expects at \code{prep()} and \code{bake()} time. Controlled using the
\code{stage} argument. Can be used by functions that interact with recipes to
verify data is correct before passing it to \code{prep()} and \code{bake()}.

\code{\link[=recipes_ptype_validate]{recipes_ptype_validate()}} checks that a recipe and its data are compatible
using information extracted using \code{\link[=recipes_ptype]{recipes_ptype()}}. Can be used by functions
that interact with recipes to verify data is correct before passing it to
\code{prep()} and \code{bake()}.

\code{\link[=detect_step]{detect_step()}} returns a logical indicator to determine if a given step or
check is included in a recipe.

\code{\link[=fully_trained]{fully_trained()}} returns a logical indicator if the recipe is fully trained.
The function \code{\link[=is_trained]{is_trained()}} can be used to check in any individual steps are
trained or not.

\code{\link[=.get_data_types]{.get_data_types()}} is an S3 method that is used for \link{selections}. This method
can be extended to work with column types not supported by recipes.

\code{\link[=recipes_extension_check]{recipes_extension_check()}} is recommended to be used by package authors to
make sure that all steps have \verb{prep.step_*()}, \verb{bake.step_*()},
\verb{print.step_*()}, \verb{tidy.step_*()}, and \verb{required_pkgs.step_*()} methods. It
should be used as a test, preferably like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{test_that("recipes_extension_check", \{
  expect_snapshot(
    recipes::recipes_extension_check(
      pkg = "pkgname"
    )
  )
\})
}\if{html}{\out{</div>}}
}

