% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{countries}
\alias{countries}
\title{Countries of occurrence.}
\usage{
countries(spData, zone = NULL, ISO = FALSE)
}
\arguments{
\item{spData}{One of three options: 1) matrix of longitude and latitude (two columns) of each occurrence record; 2) matrix of easting and northing (two columns, e.g. UTM) of each occurrence record in meters;  3) RasterLayer object of predicted distribution (0/1 values).}

\item{zone}{UTM zone if data is in metric units.}

\item{ISO}{Outputs either country names (FALSE) or ISO codes (TRUE).}
}
\value{
A vector with country names or codes.
}
\description{
Extracts the names or ISO codes of countries of occurrence of a species based on either records or predicted distribution.
}
\details{
Country boundaries and designations are based on data(worldborders) from package maptools.
}
\examples{
data(red.records)
data(red.range)
countries(red.records)
countries(red.range, ISO = TRUE)
}
