% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{red.examples}
\alias{red.examples}
\title{Example data packaged with *red*}
\source{
This function is inspired by `palmerpanguins::path_to_file()`
which in turn is based on `readxl::readxl_example()`.
}
\usage{
red.examples(data = NULL)
}
\arguments{
\item{data}{Name of data in quotes. E.g.: `"red.records"`
If `NULL`, the example files will be listed.}
}
\description{
Load data included in the package. This includes *red.records*,
a matrix of longitude and latitude (two columns) occurrence records for
Hogna maderiana (Walckenaer, 1837); *red.range*, a SpatRaster object, as
defined by package terra, of the geographic range of Hogna maderiana
(Walckenaer, 1837); *red.layers*, a SpatRaster object with layers 
representing the average annual temperature, total annual precipitation,
altitude and landcover for Madeira Island
(Fick & Hijmans 2017, Tuanmu & Jetz 2014); and *worldborders* is a small vector
of global country borders.
}
\examples{
red.examples()
red.examples("red.range")
}
