% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plotMcf}
\alias{plotMcf}
\alias{plotMcf,rateRegMcf-method}
\alias{plotMcf,sampleMcf-method}
\title{Plot Mean Cumulative Function (MCF)}
\usage{
plotMcf(object, conf.int = FALSE, ...)

\S4method{plotMcf}{sampleMcf}(object, conf.int = FALSE, mark.time = FALSE,
  lty, col, ...)

\S4method{plotMcf}{rateRegMcf}(object, conf.int = FALSE, lty, col, ...)
}
\arguments{
\item{object}{An object used to dispatch a method.}

\item{conf.int}{A logical value indicating
whether to plot confidence interval.
The default value is \code{FALSE}.}

\item{...}{Other arguments for further usage.}

\item{mark.time}{A logical value with default \code{FALSE}.
If \code{TRUE}, each censoring time is marked by "+" on the MCF curves.
Otherwise, the censoring time would not be marked.}

\item{lty}{An optional numeric vector indicating
line types specified to different groups:
0 = blank, 1 = solid, 2 = dashed, 3 = dotted, 
4 = dotdash, 5 = longdash, 6 = twodash.}

\item{col}{An optional character vector indicating
line colors specified to different groups.}
}
\value{
A \code{ggplot} object.
}
\description{
An S4 class generic function dispatched to a certain method 
to plot mean cumulative function by using \code{ggplot2} plotting system. 
The plots generated are able to be further customized properly.
}
\section{Methods (by class)}{
\itemize{
\item \code{sampleMcf}: Plot sample MCF from data.

\item \code{rateRegMcf}: Plot estimated MCF from a fitted model.
}}
\examples{
## See examples given in function mcf and rateReg.
}
\seealso{
\code{\link{mcf}} for estimation of MCF;
\code{\link{rateReg}} for model fitting.
}

