% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_plans.R
\name{redist.plot.distr_qtys}
\alias{redist.plot.distr_qtys}
\title{Plot quantities by district}
\usage{
redist.plot.distr_qtys(
  plans,
  qty,
  sort = "asc",
  geom = "jitter",
  color_thresh = NULL,
  ...
)
}
\arguments{
\item{plans}{the \code{redist_plans} object.}

\item{qty}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the
quantity of interest.}

\item{sort}{set to \code{"asc"} to sort districts in ascending order of
\code{qty} (the default), \code{"desc"} for descending order, or
\code{FALSE} or \code{"none"} for no sorting.}

\item{geom}{the geom to use in plotting the simulated districts: either
\code{"jitter"} or \code{"boxplot"}}

\item{color_thresh}{if a number, the threshold to use in coloring the points.
Plans with quantities of interest above the threshold will be colored
differently than plans below the threshold.}

\item{...}{passed on to \code{\link[ggplot2]{geom_boxplot}}}
}
\value{
A ggplot
}
\description{
Plots a boxplot of a quantity of interest across districts, with districts
optionally sorted by this quantity. Adds reference points for each reference
plan, if applicable.
}
\examples{
library(dplyr)
data(iowa)

iowa = redist_map(iowa, existing_plan=cd_2010, pop_tol=0.05, total_pop = pop)
plans = redist_smc(iowa, nsims=100, silent=TRUE)
plans \%>\%
    mutate(pct_dem = group_frac(iowa, dem_08, tot_08)) \%>\%
    redist.plot.distr_qtys(pct_dem)

}
\concept{plot}
