% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumpart.R
\name{redist.prep.enumpart}
\alias{redist.prep.enumpart}
\title{Prepares a run of the enumpart algorithm by ordering edges}
\usage{
redist.prep.enumpart(adj, unordered_path, ordered_path, adjlist)
}
\arguments{
\item{adj}{zero indexed adjacency list}

\item{unordered_path}{valid path to output the unordered adjacency map to}

\item{ordered_path}{valid path to output the ordered adjacency map to}

\item{adjlist}{Deprecated, use adj. zero indexed adjacency list}
}
\value{
0 on success
}
\description{
Prepares a run of the enumpart algorithm by ordering edges
}
\examples{
\dontrun{
temp <- tempdir()
data(fl25)
adj <- redist.adjacency(fl25)
redist.prep.enumpart(adj = adj, unordered_path = paste0(temp, '/unordered'),
                     ordered_path = paste0(temp, '/ordered'))
}
}
\references{
Benjamin Fifield, Kosuke Imai, Jun Kawahara, and Christopher T Kenny.
"The Essential Role of Empirical Validation in Legislative Redistricting Simulation."
Forthcoming, Statistics and Public Policy.
}
\concept{enumerate}
