% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_map.R
\name{plot.redist_map}
\alias{plot.redist_map}
\title{Plot a \code{redist_map}}
\usage{
\method{plot}{redist_map}(x, fill = NULL, by_distr = FALSE, adj = FALSE, ...)
}
\arguments{
\item{x}{the \code{redist_map} object}

\item{fill}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} If
present, will be used to color the map units. If using data masking, may
need to explicitly name argument \code{fill=...} in non-interactive
contexts to avoid S3 generic issues.}

\item{by_distr}{if \code{TRUE} and \code{fill} is not missing and, color by
district and indicate the \code{fill} variable by shading.}

\item{adj}{if \code{TRUE}, force plotting the adjacency graph. Overrides
\code{by_distr}.}

\item{...}{passed on to \code{\link{redist.plot.map}} (or
\code{\link{redist.plot.adj}} if \code{adj=TRUE}).
Useful parameters may include \code{zoom_to}, \code{boundaries}, and
\code{title}.}
}
\value{
ggplot2 object
}
\description{
Plot a \code{redist_map}
}
\examples{
data(fl25)
d <- redist_map(fl25, ndists = 3, pop_tol = 0.05)
plot(d)
plot(d, BlackPop/pop)

data(fl25_enum)
fl25$dist <- fl25_enum$plans[, 5118]
d <- redist_map(fl25, existing_plan = dist)
plot(d)

}
\concept{plot}
\concept{prepare}
