% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist_info}
\alias{dist_info}
\title{Calculate Variation of Information Distances}
\usage{
dist_info(plans, shp, total_pop, ncores = 1)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{total_pop}{unqouted name of column in shp with total population}

\item{ncores}{numeric. Number of cores to use. Default is 1.}
}
\value{
matrix of plan distances
}
\description{
Calculate Variation of Information Distances
}
\examples{
data(nh)
data(nh_m)
# For a single plan (distance is trivial, 0):
dist_info(plans = nh$r_2020, shp = nh, total_pop = pop)

# Or many plans:
dist_info(plans = nh_m[, 3:5], shp = nh, total_pop = pop)

}
\concept{distances}
