% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{splits_total}
\alias{splits_total}
\title{Count the Total Splits in Each Plan}
\usage{
splits_total(plans, shp, admin)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object, tibble, or data frame containing other columns}

\item{admin}{unqouted name of column in shp with numeric identifiers for administrative units}
}
\value{
numeric matrix
}
\description{
Counts the total number of administrative splits.
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
splits_total(plans = nh$r_2020, shp = nh, admin = county)

# Or many plans:
splits_total(plans = nh_m[, 3:5], shp = nh, admin = county)

}
\concept{splits}
