% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_CDScoords.R
\name{refseq_CDScoords}
\alias{refseq_CDScoords}
\title{Extract the coding sequences (CDS) coordinates from a XM accession}
\usage{
refseq_CDScoords(xm)
}
\arguments{
\item{xm}{A character string of the single/multiple XM id.}
}
\value{
An \code{IRanges} object with the start and end position of the CDS of the
putative mRNAs.
}
\description{
\code{refseq_CDScoords()} Parses an XM accession (Genbank format) and extract the CDS coordinates.
The CDS coordinates refer to the mRNA molecule.
}
\examples{
xm = c("XM_004487701")
refseq_CDScoords(xm)

\donttest{
xm = c("XM_004487701", "XM_004488493")
refseq_CDScoords(xm)}

}
\seealso{
\code{\link{refseq_CDSseq}}
}
\author{
Jose V. Die
}
