% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_fromGene.R
\name{refseq_fromGene}
\alias{refseq_fromGene}
\title{Get the mRNA or protein accession}
\usage{
refseq_fromGene(gene_symbol,sequence, retries)
}
\arguments{
\item{gene_symbol}{A character string of the gene symbol.}

\item{sequence}{A character string of the "XM" or "XP" to fetch data from mRNA or protein databases, respectively.}

\item{retries}{A numeric value to control the number of retry attempts to handle 502 errors.}
}
\value{
A character vector containing the XP or XM id accessions corresponding to the especified \verb{gene symbol}.
}
\description{
\code{refseq_fromGene()} Returns the XP or XM accession from a single gene id. accession.
}
\examples{
\donttest{
# Get the XM accessions from a set of gene ids
locs <- c("LOC101512347")
sapply(locs, function(x) refseq_fromGene (x, sequence = "XM", retries = 3), USE.NAMES = FALSE)

# Get the XP accessions from a set of gene ids
locs <- c("LOC101512347")
sapply(locs, function(x) refseq_fromGene (x, sequence = "XP", retries = 3), USE.NAMES = FALSE)}

}
\seealso{
\code{\link{refseq_XMfromXP}} to obtain the XM ids that encode a set of XP ids.

\code{\link{refseq_XPfromXM}} to obtain the XP ids encoded by a set of XM ids.
}
\author{
Jose V. Die
}
