% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_GeneID.R
\name{refseq_GeneID}
\alias{refseq_GeneID}
\title{Get the GeneID}
\usage{
refseq_GeneID (accession, db, retries)
}
\arguments{
\item{accession}{A character string of the transcript or protein accession.}

\item{db}{A character string of the "nuccore" or "protein" database.}

\item{retries}{A numeric value to control the number of retry attempts to handle internet errors.}
}
\value{
A character vector containing the GeneID corresponding to the specified accession as \code{accession}.
}
\description{
\code{refseq_GeneID()} Returns the GeneID from a single transcript or protein accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
# Get the gene symbol from a set of transcript accessions
transcript = c("XM_004487701", "XM_004488493")
sapply(transcript, function(x) refseq_GeneID (x, db = "nuccore", retries = 4), USE.NAMES = FALSE)

# Get the gene symbol from a set of protein accessions
protein = c("XP_004487758")
sapply(protein, function(x) refseq_GeneID (x, db = "protein", retries = 4), USE.NAMES = FALSE)

}
\seealso{
\code{\link{refseq_protein2RNA}} to obtain the transcript accessions that encode a set of protein accessions.

\code{\link{refseq_RNA2protein}} to obtain the protein accessions encoded by a set of transcript accessions.
}
\author{
Jose V. Die
}
