% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.r
\name{d_phi_proxy}
\alias{d_phi_proxy}
\title{Partial derivatives for mean impact equation using proxy data.}
\usage{
d_phi_proxy(
  p_impact,
  prox_data,
  mean_predictors,
  var_predictors,
  cov,
  samp_size,
  num_items
)
}
\arguments{
\item{p_impact}{Vector of impact parameters.}

\item{prox_data}{Matrix of observed proxy scores.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{cov}{Covariate being maximized.}

\item{samp_size}{Sample size in dataset.}

\item{num_items}{Number of items in dataset.}
}
\value{
a \code{"list"} of first and second partial derivatives for variance impact equation (to
use with coordinate descent and univariate Newton-Raphson)
}
\description{
Partial derivatives for mean impact equation using proxy data.
}
\keyword{internal}
