% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regRNN.R
\name{regRNN}
\alias{regRNN}
\alias{regRNN.default}
\alias{regRNN.formula}
\title{Reduced Nearest Neighbors for Regression}
\usage{
\method{regRNN}{default}(x, y, t = 0.2, ...)

\method{regRNN}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{t}{a double in [0,1] with the \emph{threshold} used by regression noise filter (default: 0.2).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata}, \link{summary.rfdata} and \link{plot.rfdata} methods.
}
\description{
Application of the regRNN noise filtering method in a regression dataset.
}
\details{
In classification, \emph{Reduced Nearest Neighbors} (RNN) is an enhancement of CNN that includes one more step,
which removes samples in the dataset that do not affect the performance of the \emph{k}-NN classifier.
The implementation of this noise filter to be used in regression problems follows the proposal of Martín \emph{et al.} (2021),
which is based on the use of a noise threshold (\code{t}) to determine the similarity between the output variable of the samples.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- regRNN(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- regRNN(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
G. Gates,
\strong{The reduced nearest neighbor rule (Corresp.)},
\emph{IEEE Transactions on Information Theory}, 18:431-433, 1972.
\doi{https://doi.org/10.1109/TIT.1972.1054809}.

J. Martín, J. A. Sáez and E. Corchado,
\strong{On the regressand noise problem: Model robustness and synergy with regression-adapted noise filters.}
\emph{IEEE Access}, 9:145800-145816, 2021.
\doi{https://doi.org/10.1109/ACCESS.2021.3123151}.
}
\seealso{
\code{\link{regCNN}}, \code{\link{regBBNR}}, \code{\link{regENN}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
