% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_means.R
\name{cell_means_q}
\alias{cell_means_q}
\alias{cell_means_q.lm}
\alias{cell_means_q.aov}
\alias{cell_means_q.glm}
\title{Estimated values of a linear model.}
\usage{
cell_means_q(model, ...)

\method{cell_means_q}{lm}(model, vars = NULL, levels = NULL, ...)

\method{cell_means_q}{aov}(model, vars = NULL, levels = NULL, ...)

\method{cell_means_q}{glm}(model, vars = NULL, levels = NULL,
  type = c("link", "response"), ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm', 'aov', or 'glm'.}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}

\item{vars}{A vector or list with variable names to be added to the table.}

\item{levels}{A list with element names corresponding to some or all of the
variables in the model. Each list element should be a vector with the names
of factor levels (for categorical variables) or numeric points (for
continuous variables) at which to test that variable.}

\item{type}{The type of prediction required. The default 'link' is on the
scale of the linear predictors; the alternative 'response' is on the scale
of the response variable. For more information, see
\code{\link{predict.glm}}.}
}
\value{
A data frame with a row for each predicted value. The first few
  columns identify the level at which each variable in your model was set.
  After columns for each variable, the data frame has columns for the
  predicted value, the standard error of the predicted mean, and the 95\%
  confidence interval.
}
\description{
\code{cell_means_q} calculates the predicted values at specific points,
given a fitted regression model (linear, generalized, or ANOVA).
}
\details{
By default, this function will provide means at -1 SD, the mean, and +1 SD
for continuous variables, and at each level of categorical variables. This
can be overridden with the \code{levels} parameter.

If there are additional covariates in the model other than what are selected
in the function call, these variables will be set to their respective means.
In the case of a categorical covariate, the results will be averaged across
all its levels.

Note that in most cases it is easier to use \code{\link{cell_means}} and
pass variable names in directly instead of strings of variable names.
\code{cell_means_q} uses standard evaluation in cases where such evaluation
is easier.
}
\section{Methods (by class)}{
\itemize{
\item \code{lm}: Estimated values for a linear model.

\item \code{aov}: Estimated means for ANOVA.

\item \code{glm}: Estimated values for a generalized linear model.
}}

\examples{
# iris data
model <- lm(Sepal.Length ~ Petal.Length + Petal.Width, iris)
summary(model)
cell_means_q(model, 'Petal.Length')
}
\seealso{
\code{\link{cell_means}}
}
