% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_functional_data.R
\name{simulate_functional_data}
\alias{simulate_functional_data}
\title{Simulate functional data}
\usage{
simulate_functional_data(
  lambda1 = 2,
  lambda2 = 1,
  I = 50,
  D = 100,
  seed = 1988,
  vary_D = FALSE
)
}
\arguments{
\item{lambda1}{Standard deviation for PC1 scores.}

\item{lambda2}{Standard deviation for PC2 scores.}

\item{I}{Number of subjects. Defaults is 50.}

\item{D}{Number of grid points per subject. Default is 100.}

\item{seed}{Seed for reproducibility. Default is 1988.}

\item{vary_D}{Indicates if grid length vary by subject. If FALSE all subjects have grid length D.}
}
\value{
A list containing:
\item{Y}{Simulated dataframe with variables id, value, index, and latent_mean.}
\item{psi1}{True values for first principal component.}
\item{psi2}{True values for second principal component.}
\item{alpha}{True values for population-level mean.}

A list containing:
\item{Y}{A dataframe of simulated data.}
\item{psi1}{The first simulated eigenfunction.}
\item{psi2}{The second simulated eigenfunction.}
\item{alpha}{The population mean.}
}
\description{
This function simulates functional data. The data it outputs is generated from a mean function
and two orthogonal principal component basis functions. The mean and principal components are 
based on sine and cosine functions. Subject-specific scores for each PC are drawn from normal 
distributions with standard deviation lambda1 and lambda2.
}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu}
}
