% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.haplohh.R
\name{plot.haplohh}
\alias{plot.haplohh}
\title{Plot the variants of a haplohh object}
\usage{
\method{plot}{haplohh}(
  x,
  mrk = NA,
  allele = NA,
  group_by_allele = FALSE,
  ignore.distances = FALSE,
  col = c("blue", "red", "violet", "orange"),
  linecol = "gray",
  mrk.col = "gray",
  pch = 19,
  cex = 1,
  lwd = 1,
  hap.names = NULL,
  mrk.names = NULL,
  cex.lab.hap = 0.8,
  cex.lab.mrk = 0.8,
  family.lab = "",
  offset.lab.hap = 0.5,
  offset.lab.mrk = 0.25,
  pos.lab.hap = "left",
  pos.lab.mrk = "top",
  srt.hap = 0,
  srt.mrk = 0,
  ...
)
}
\arguments{
\item{x}{an object of class \code{haplo-hh} generated by \code{\link{data2haplohh}}.}

\item{mrk}{the focal marker. Used only, if alleles are grouped or (de-)selected.}

\item{allele}{if \code{NA} (default), haplotypes of all alleles are plotted,
otherwise for the specified alleles. Alleles must be specified by their
internal coding, i.e. '0' for ancestral resp. major allele, etc.
Haplotypes with missing values at the focal marker can only be selected in
combination with genotyped alleles, e.g. as \code{c(1,NA)}.}

\item{group_by_allele}{logical. If \code{TRUE}, group chromosomes
by their allele at the focal marker; alleles are ordered by their internal coding
unless parameter \code{alleles} is specified. If \code{FALSE} (default), haplotypes are drawn by
their order in the input file.}

\item{ignore.distances}{logical. If \code{TRUE}, markers are drawn equally-spaced.}

\item{col}{color for each allele (as coded internally).}

\item{linecol}{the color of the background lines. If more than one color is specified and sequences
sorted by the marker allele, the specified colors are used to distinguish the alleles; otherwise
consecutive sequences are set into the specified colors.}

\item{mrk.col}{color of the vertical line at the focal marker position.}

\item{pch}{symbol used for markers. See \code{\link[graphics]{points}}.}

\item{cex}{relative size of marker symbol. See \code{\link[graphics]{points}}.}

\item{lwd}{line width.}

\item{hap.names}{a vector containing the names of chromosomes.}

\item{mrk.names}{a vector containing the names of markers.}

\item{cex.lab.hap}{relative letter size of haplotype labels. See \code{\link[graphics]{par}}.}

\item{cex.lab.mrk}{relative letter size of marker labels. See \code{\link[graphics]{par}}.}

\item{family.lab}{font family for labels. See \code{\link[graphics]{par}}.}

\item{offset.lab.hap}{offset of haplotype labels. See \code{\link[graphics]{par}}.}

\item{offset.lab.mrk}{offset of marker labels. See \code{\link[graphics]{par}}.}

\item{pos.lab.hap}{position of haplotype labels. Either \code{"left"} (default),
\code{"right"}, \code{"none"} or \code{"both"}.}

\item{pos.lab.mrk}{position of marker labels. Either \code{"top"} (default) or \code{"none"}.}

\item{srt.hap}{rotation of haplotype labels (see \code{\link[graphics]{par}}).}

\item{srt.mrk}{rotation of marker labels (see \code{\link[graphics]{par}}).}

\item{...}{other parameters to be passed to \code{\link[graphics]{plot.default}}.}
}
\description{
Plot the variants of a haplohh object. This method is intended
for visualization of very small data sets such as the examples
provided by the package.
}
\details{
Specifying a haplohh-object with more than 4096 haplotypes or
markers produces an error.
}
\examples{
#example haplohh object
make.example.files()
hh <- data2haplohh("example1.vcf")
plot(hh)
hh <- data2haplohh("example2.vcf", min_perc_geno.mrk = 50)
plot(hh)
remove.example.files()
}
\seealso{
\code{\link{calc_haplen}}, \code{\link{plot.furcation}}.
}
