% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeCSV.R
\name{writeCSV}
\alias{writeCSV}
\title{Saves/writes population frequencies to disk}
\usage{
writeCSV(fileName, pop, n = 100, delim = ",")
}
\arguments{
\item{fileName}{the name and path where the population profiles are to be
saved to.}

\item{pop}{a \code{list} containing elements \code{loci} and \code{freqs}. \code{loci}
is a vector with the loci in the data set. \code{freqs} is a list of vectors with elements
named after the elements in \code{loci}. Each locus in \code{freqs} is a vector of allele frequencies
with the allele names given by the named elements.
\code{TRUE} then an Amelogenin marker is added to the population, and all
the profiles are set to male XY, although this is coded to 1,2 to keep the
allele designations numeric.}

\item{n}{the number of people in the database. This is arbitrarily set to 100 by default.}

\item{delim}{The allele delimiter.}
}
\value{
a matrix which contains the table written to file.
}
\description{
Writes a population of profiles to disk using the original allele
designations rather than the internal integer representations that are used
for the other functions.
}
\note{
Rare alleles are recoded to 108.1. This is unlikely to do the right thing
when you have things like <5 or >20 in your allele names. Given it is impossible to 
predict what a user would like to do, I suggest you recode them yourself before using
this function.
}
\examples{

data(USCaucs)
\dontrun{
  writeCSV("USCaucs.csv", USCaucs)
}

}
\seealso{
breedFst USCaucs
}
\author{
James M. Curran
}
