% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opm_MI_delta.R
\name{opm_MI_delta}
\alias{opm_MI_delta}
\title{Apply Delta adjustment to Update JAGS MCMC outputs under MAR for Cumulative Logistic Model}
\usage{
opm_MI_delta(object, treatment, delta = 0, start = NULL, end = NULL,
  thin = NULL, exclude_chains = NULL, subset = FALSE, seed = NULL,
  mess = FALSE, ...)
}
\arguments{
\item{object}{an object of class remiod}

\item{treatment}{the variable name of treatment. Reference level of treatment should be coded as 0.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{start}{first iteration to be used.}

\item{end}{last iteration to be used.}

\item{thin}{thinning to be applied.}

\item{exclude_chains}{optional vector of numbers, indexing MCMC chains to be excluded from the output.}

\item{subset}{subset of parameters (columns of the mcmc object) to be used.}

\item{seed}{optional seed value.}

\item{mess}{logical, should messages be displayed?}

\item{...}{optional arguments pass from main function.}
}
\value{
A matrix of MCMC samples with all monitored parameters.A subset of
the MCMC sample can be selected using \code{start}, \code{end} and
\code{thin}.
}
\description{
Internal function to obtain delta-adjusted MCMC from an MAR object.
}
