% Generated by roxygen2 (4.0.1): do not edit by hand
\name{EotCycle}
\alias{EotCycle}
\title{Calculate a single EOT}
\usage{
EotCycle(x, y, y.eq.x = FALSE, n = 1, standardised, orig.var, write.out,
  path.out, prefix, type, verbose, ...)
}
\arguments{
\item{x}{a ratser stack used as predictor}

\item{y}{a RasterStack used as response. If \code{y} is \code{NULL},
\code{x} is used as \code{y}}

\item{y.eq.x}{logical. Whether predictor and response stack are the same}

\item{n}{the number of EOT modes to calculate}

\item{standardised}{logical. If \code{FALSE} the calculated r-squared values
will be multiplied by the variance}

\item{orig.var}{original variance of the response domain}

\item{write.out}{logical. If \code{TRUE} results will be written to disk
using \code{path.out}}

\item{path.out}{the file path for writing results if \code{write.out} is \code{TRUE}.
Defaults to current working directory}

\item{prefix}{optional prefix to be used for naming of results if
\code{write.out} is \code{TRUE}}

\item{type}{the type of the link function. Defaults to \code{'rsq'} as in original
proposed method from \cite{Dool2000}. If set to \code{'ioa'} index of agreement is
used instead}

\item{verbose}{logical. If \code{TRUE} some details about the
calculation process will be output to the console}

\item{...}{not used at the moment}
}
\description{
EotCycle() calculates a single EOT and is controlled by the main eot() function
}

