% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-version.R
\name{install_version}
\alias{install_version}
\title{Install specified version of a CRAN package.}
\usage{
install_version(package, version = NULL, repos = getOption("repos"),
  type = getOption("pkgType"), ...)
}
\arguments{
\item{package}{package name}

\item{version}{If the specified version is NULL or the same as the most
recent version of the package, this function simply calls
\code{install.packages}. Otherwise, it looks at the list of
archived source tarballs and tries to install an older version instead.}

\item{repos}{
    character vector, the base URL(s) of the repositories
    to use, e.g., the URL of a CRAN mirror such as
    \code{"http://cran.us.r-project.org"}.  For more details on
    supported URL schemes see \code{\link{url}}.

    Can be \code{NULL} to install from local files, directories or URLs:
    this will be inferred by extension from \code{pkgs} if of length one.
  }

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some OS X
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{...}{Other arguments passed on to \code{install.packages}.}
}
\description{
If you are installing an package that contains compiled code, you will
need to have an R development environment installed.  You can check
if you do by running \code{devtools::has_devel} (you need the
\code{devtools} package for this).
}
\author{
Jeremy Stephens
}

