% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_normality.R
\name{nice_normality}
\alias{nice_normality}
\title{Easy normality check per group}
\usage{
nice_normality(
  data,
  variable,
  group,
  colours,
  groups.labels,
  grid = TRUE,
  shapiro = FALSE,
  title = NULL,
  histogram = FALSE,
  breaks.auto = FALSE,
  ...
)
}
\arguments{
\item{data}{The data frame.}

\item{variable}{The dependent variable to be plotted.}

\item{group}{The group by which to plot the variable.}

\item{colours}{Desired colours for the plot, if desired.}

\item{groups.labels}{How to label the groups.}

\item{grid}{Logical, whether to keep the default background grid
or not. APA style suggests not using a grid in the background,
though in this case some may find it useful to more easily
estimate the slopes of the different groups.}

\item{shapiro}{Logical, whether to include the p-value from
the Shapiro-Wilk test on the plot.}

\item{title}{An optional title, if desired.}

\item{histogram}{Logical, whether to add an histogram
on top of the density plot.}

\item{breaks.auto}{If histogram = TRUE, then option to set bins/breaks
automatically, mimicking the default behaviour of
base R \code{hist()} (the Sturges method). Defaults to
\code{FALSE}.}

\item{...}{Further arguments from \code{nice_qq()} and
\code{nice_density()} to be passed to \code{nice_normality()}}
}
\value{
A plot of classes patchwork and ggplot, containing two plots,
resulting from \code{\link{nice_density}} and \code{\link{nice_qq}}.
}
\description{
Easily make nice per-group density and QQ plots
through a wrapper around the \code{ggplot2} and \code{qqplotr} packages.
}
\examples{
# Make the basic plot
nice_normality(
  data = iris,
  variable = "Sepal.Length",
  group = "Species"
)

# Further customization
nice_normality(
  data = iris,
  variable = "Sepal.Length",
  group = "Species",
  colours = c(
    "#00BA38",
    "#619CFF",
    "#F8766D"
  ),
  groups.labels = c(
    "(a) Setosa",
    "(b) Versicolor",
    "(c) Virginica"
  ),
  grid = FALSE,
  shapiro = TRUE
)

}
\seealso{
Other functions useful in assumption testing:
\code{\link{nice_assumptions}}, \code{\link{nice_density}},
\code{\link{nice_qq}}, \code{\link{nice_var}},
\code{\link{nice_varplot}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{QQ}
\keyword{density}
\keyword{distribution}
\keyword{normality}
\keyword{plots}
