% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.R
\name{use}
\alias{use}
\title{Use a set of Packages}
\usage{
use(..., library = NULL, isolate = FALSE, attach = TRUE, verbose = FALSE)
}
\arguments{
\item{...}{The \R packages to be used with this script.}

\item{library}{The library path into which the requested packages should be installed.
When \code{NULL} (the default), a library path within the \R temporary
directory will be generated and used. Note that this same library path
will be re-used on future calls to \code{renv::use()}, allowing \code{renv::use()}
to be used multiple times within a single script.}

\item{isolate}{Boolean; should the active library paths be included in the set of library
paths activated for this script? Set this to \code{TRUE} if you only want the
packages provided to \code{renv::use()} to be visible on the library paths.}

\item{attach}{Boolean; should the set of requested packages be automatically attached?
If \code{TRUE} (the default), packages will be loaded and attached via a call
to \code{\link[=library]{library()}} after install.}

\item{verbose}{Boolean; be verbose while installing packages?}
}
\value{
This function is normally called for its side effects.
}
\description{
Given a set of \R package requirements, install those packages into the
library path requested via \code{library}, and then activate that library path.
}
\details{
\code{renv::use()} is intended to be used within standalone \R scripts. It can
be useful when you'd like to specify an \R script's dependencies directly
within that script, and have those packages automatically installed and
loaded when the associated script is run. In this way, an \R script can more
easily be shared and re-run with the exact package versions requested via
\code{use()}.

\code{renv::use()} is inspired in part by the \href{https://groundhogr.com/}{groundhog}
package, which provides an alternate mechanism for specifying a script's
\R package requirements within that same \R script.
}
