% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{history}
\alias{history}
\title{View Lockfile History}
\usage{
history(project = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
An \R \code{data.frame}, summarizing the commits in which \code{renv.lock}
has been mutated.
}
\description{
Use your version control system to find prior versions of the \code{renv.lock}
file that have been used in your project.
}
\details{
The \code{history()} function is currently only implemented for projects using
\code{git} for version control.
}
\examples{
\dontrun{

# get history of previous versions of renv.lock in VCS
db <- renv::history()

# choose an older commit
commit <- db$commit[5]

# revert to that version of the lockfile
renv::revert(commit = commit)

}
}
