% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Run a Script}
\usage{
run(script, ..., job = NULL, name = NULL, project = NULL)
}
\arguments{
\item{script}{The path to an \R script.}

\item{...}{Optional arguments; reserved for future expansion.}

\item{job}{Run the requested script as an RStudio job? Requires a recent
version of both RStudio and the \code{rstudioapi} packages. When \code{NULL}, the
script will be run as a job if possible, and as a regular \R process
launched by \code{\link[=system2]{system2()}} if not.}

\item{name}{The name to associate with the job, for scripts run as a job.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Run an \R script, with an \code{renv} project active. The script will be run as
an \R sub-process.
}
