% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install Packages}
\usage{
install(
  packages = NULL,
  ...,
  library = NULL,
  rebuild = FALSE,
  confirm = interactive(),
  project = NULL
)
}
\arguments{
\item{packages}{A character vector of \R packages to install. Required
package dependencies (\code{Depends}, \code{Imports}, \code{LinkingTo}) will be installed
as required.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that the requested package(s) should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{confirm}{Boolean; prompt the user before taking any action?}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Install one or more \R packages from a variety of remote sources.
}
\details{
\code{install()} uses the same machinery as \code{\link[=restore]{restore()}} when installing packages.
In particular, this means that the local cache of package installations is
used when possible. This helps to avoid re-downloading packages that have
already been downloaded before, and re-compiling packages from source when
a binary copy of that package is already available.

Note that this interface is subject to change -- the goal is to hook into
separate package installation backends in the future.
}
\examples{
\dontrun{

# install the latest version of 'digest'
renv::install("digest")

# install an old version of 'digest' (using archives)
renv::install("digest@0.6.18")

# install 'digest' from GitHub (latest dev. version)
renv::install("eddelbuettel/digest")

# install a package from local sources
renv::install("~/path/to/package")

}
}
