% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{history}
\alias{history}
\alias{revert}
\title{View and revert to a historical lockfile}
\usage{
history(project = NULL)

revert(commit = "HEAD", ..., project = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{commit}{The commit associated with a prior version of the lockfile.}

\item{...}{Optional arguments; currently unused.}
}
\value{
\code{history()} returns a \code{data.frame} summarizing the commits in which
\code{renv.lock} has been changed. \code{revert()} is usually called for its
side-effect but also invisibly returns the \code{commit} used.
}
\description{
\code{history()} uses your version control system to show prior versions of the
lockfile and \code{revert()} allows you to restore one of them.

These functions are currently only implemented for projects that use git.
}
\examples{
\dontrun{

# get history of previous versions of renv.lock in VCS
db <- renv::history()

# choose an older commit
commit <- db$commit[5]

# revert to that version of the lockfile
renv::revert(commit = commit)

}
}
