% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\docType{data}
\name{settings}
\alias{settings}
\title{Project settings}
\usage{
settings
}
\value{
A named list of renv settings.
}
\description{
Define project-local settings that can be used to adjust the behavior of
renv with your particular project.
\itemize{
\item Get the current value of a setting with (e.g.) \code{settings$snapshot.type()}
\item Set current value of a setting with (e.g.)
\code{settings$snapshot.type("explicit")}.
}

Settings are automatically persisted across project sessions by writing to
\code{renv/settings.json}. You can also edit this file by hand, but you'll need
to restart the session for those changes to take effect.
\subsection{\code{bioconductor.version}}{

The Bioconductor version to be used with this project. Use this if you'd
like to lock the version of Bioconductor used on a per-project basis.
When unset, renv will try to infer the appropriate Bioconductor release
using the BiocVersion package if installed; if not, renv uses
\code{BiocManager::version()} to infer the appropriate Bioconductor version.
}

\subsection{\code{external.libraries}}{

A vector of library paths, to be used in addition to the project's own
private library. This can be useful if you have a package available for use
in some system library, but for some reason renv is not able to install
that package (e.g. sources or binaries for that package are not publicly
available, or you have been unable to orchestrate the pre-requisites for
installing some packages from source on your machine).
}

\subsection{\code{ignored.packages}}{

A vector of packages, which should be ignored when attempting to snapshot
the project's private library. Note that if a package has already been
added to the lockfile, that entry in the lockfile will not be ignored.
}

\subsection{\code{package.dependency.fields}}{

When installing a package with \code{install()}, what \code{DESCRIPTION} fields should
be used to determine that package's dependencies? The default uses
\code{c("Imports", "Depends", "LinkingTo")}, but if you also want  to install
\code{Suggests} dependencies for a package, you can set this to
\code{c("Imports", "Depends", "LinkingTo", "Suggests")}.
}

\subsection{\code{ppm.enabled}}{

Enable \href{https://packagemanager.posit.co/}{Posit Package Manager}
integration in this project? When \code{TRUE}, renv will attempt to transform
repository URLs used by PPM into binary URLs as appropriate for the
current Linux platform. Set this to \code{FALSE} if you'd like to continue using
source-only PPM URLs, or if you find that renv is improperly transforming
your repository URLs. You can still set and use PPM repositories with this
option disabled; it only controls whether renv tries to transform source
repository URLs into binary URLs on your behalf.
}

\subsection{\code{ppm.ignored.urls}}{

When \href{https://packagemanager.posit.co/}{Posit Package Manager} integration
is enabled, \code{renv} will attempt to transform source repository URLs into
binary repository URLs. This setting can be used if you'd like to avoid this
transformation with some subset of repository URLs.
}

\subsection{\code{r.version}}{

The version of \R to encode within the lockfile. This can be set as a
project-specific option if you'd like to allow multiple users to use
the same renv project with different versions of \R. renv will
still warn the user if the major + minor version of \R used in a project
does not match what is encoded in the lockfile.
}

\subsection{\code{snapshot.type}}{

The type of snapshot to perform by default. See \link{snapshot} for more
details.
}

\subsection{\code{use.cache}}{

Enable the renv package cache with this project. When active, renv will
install packages into a global cache, and link packages from the cache into
your renv projects as appropriate. This can greatly save on disk space
and install time when for \R packages which are used across multiple
projects in the same environment.
}

\subsection{\code{vcs.manage.ignores}}{

Should renv attempt to manage the version control system's ignore files
(e.g. \code{.gitignore}) within this project? Set this to \code{FALSE} if you'd
prefer to take control. Note that if this setting is enabled, you will
need to manually ensure internal data in the project's \verb{renv/} folder
is explicitly ignored.
}

\subsection{\code{vcs.ignore.cellar}}{

Set whether packages within a project-local package cellar are excluded
from version control. See \code{vignette("package-sources", package = "renv")}
for more information.
}

\subsection{\code{vcs.ignore.library}}{

Set whether the renv project library is excluded from version control.
}

\subsection{\code{vcs.ignore.local}}{

Set whether renv project-specific local sources are excluded from version
control.
}
}
\section{Defaults}{
You can change the default values of these settings for newly-created renv
projects by setting \R options for \code{renv.settings} or \verb{renv.settings.<name>}.
For example:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{options(renv.settings = list(snapshot.type = "all"))
options(renv.settings.snapshot.type = "all")
}\if{html}{\out{</div>}}

If both of the \code{renv.settings} and \verb{renv.settings.<name>} options are set
for a particular key, the option associated with \verb{renv.settings.<name>} is
used instead. We recommend setting these in an appropriate startup profile,
e.g. \verb{~/.Rprofile} or similar.
}

\examples{

\dontrun{

# view currently-ignored packaged
renv::settings$ignored.packages()

# ignore a set of packages
renv::settings$ignored.packages("devtools", persist = FALSE)

}
}
\keyword{datasets}
