% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/let.R
\name{letp}
\alias{letp}
\title{Wrap expr for \code{magrittr} pipeline execution with name substitutions specified in alias.}
\usage{
letp(., alias, expr, strict = TRUE)
}
\arguments{
\item{.}{incoming argument from \code{magrittr} pipeline (do not assign to this)}

\item{alias}{mapping from free names in expr to target names to use}

\item{expr}{\code{magrittr} pipeline to prepare for execution}

\item{strict}{logical if TRUE only allow single name replacements.}
}
\value{
result of expr executed in calling environment
}
\description{
\code{letp} implements a mapping from desired names (names used directly in the expr code) to names used in the data.
\code{letp} is a specialization of \code{let} for use in \code{magrittr} pipelines, please see \code{\link{let}}
for details.
}
\details{
\code{letp} is a variation of \code{let} needed only for inline code placed immediately after \code{\%>\%}, as in the
example below.
\code{expr} must start with "\code{ . \%>\% }" and should not attempt assignments
or other environment sensitive side-effects.
}
\examples{

library('dplyr')
d <- data.frame(Sepal_Length=c(5.8,5.7),
                Sepal_Width=c(4.0,4.4),
                Species='setosa',
                rank=c(1,2))

mapping = list(RankColumn='rank',GroupColumn='Species')
d \%>\% letp(mapping,
           . \%>\% mutate(RankColumn=RankColumn-1)
          )

# letp is only for transient pipelines, to save pipes use let:

f <- let(mapping,
         . \%>\% mutate(RankColumn=RankColumn-1)
        )
d \%>\% f

}
\seealso{
\code{\link{replyr_mapRestrictCols}} \code{\link{let}}
}
