% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{replyr_filter}
\alias{replyr_filter}
\title{Filter a tbl on a column having values in a given set.}
\usage{
replyr_filter(x, cname, values, ..., verbose = TRUE,
  tempNameGenerator = makeTempNameGenerator("replyr_filter"))
}
\arguments{
\item{x}{tbl or item that can be coerced into such.}

\item{cname}{name of the column to test values of.}

\item{values}{set of values to check set membership of.}

\item{...}{force later arguments to bind by name.}

\item{verbose}{logical if TRUE echo warnings}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}
}
\value{
new tbl with only rows where cname value is in values set.
}
\description{
Note: if temp tables can't be used a regular table is created and destroyed (which may not be safe if there is another replyr_filter running at the same time).
}
\examples{

values <- c('a','c')
d <- data.frame(x=c('a','a','b','b','c','c'),y=1:6,
                stringsAsFactors=FALSE)
replyr_filter(d,'x',values)

}
