% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_rows.R
\name{replyr_union_all}
\alias{replyr_union_all}
\title{Union two tables.}
\usage{
replyr_union_all(tabA, tabB, ..., cols = NULL,
  tempNameGenerator = makeTempNameGenerator("replyr_union_all"))
}
\arguments{
\item{tabA}{table with at least 1 row.}

\item{tabB}{table with at least on same data source as tabA and commmon columns.}

\item{...}{force later arguments to be bound by name.}

\item{cols}{list of column names to limit to (defaults to intersection), must be non-empty and contained in intersection.}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}
}
\value{
table with all rows of tabA and tabB (union_all).
}
\description{
Spark 2* union_all has issues ( https://github.com/WinVector/replyr/blob/master/issues/UnionIssue.md ),
and exponsed union_all semantics differ from data-source backend to backend.
This is an attempt to provide a join-based replacement.
NOT YET TESTED.
}
\examples{

d1 <- data.frame(x=c('a','b'))
d2 <- data.frame(x='c')
replyr_union_all(d1, d2)

}
